#Author: Dr.C. Sweetlin Hemalatha, Associate Professor, School of Computing Science & Engineering, VIT Chennai
#Ex6-Indexing and Slicing data frames
#R version 3.3.3
#RStudio version 1.2.1335
rm(list=ls())

#1.  Read the content of 'Events.csv' in a data frame and view it.
eventdata=read.csv('Events.csv')
View(eventdata)

#2.  Access the scores of participants in event2.
print(eventdata$event2)

#3.  Use index number to retrieve the same data.
print(eventdata[[3]])   #eventdata[3]

#4.  Extract the score of third participant in event3.
print(eventdata[3,4])


#5.  Extract the scores of the first and second participant in all the events.
print(eventdata[c(1,2),])

#6.  Display the names and total scores of all participants.
print(eventdata[,c(1,6)])

#7.  Make the column names as the row index of the data frame.
events <- eventdata[-1]
row.names(events)=eventdata$name
print(events)

#8.  Display the names of the students participated in event3.
e3 <- events$event3!=0
print(rownames(events)[e3])

#9.  Obtain the names whose total score is above its average.
avg <- mean(events$totalscore)
ans <- events$totalscore>avg
print(rownames(events)[ans])
